/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.utils.connections;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HttpsURLConnection;
import net.skinsrestorer.api.SkinVariant;
import net.skinsrestorer.api.SkinsRestorerAPI;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.api.interfaces.IMineSkinAPI;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.shadow.google.gson.Gson;
import net.skinsrestorer.shadow.google.gson.JsonSyntaxException;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shared.exception.TryAgainException;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.storage.Locale;
import net.skinsrestorer.shared.utils.MetricsCounter;
import net.skinsrestorer.shared.utils.Pair;
import net.skinsrestorer.shared.utils.connections.responses.mineskin.MineSkinErrorDelayResponse;
import net.skinsrestorer.shared.utils.connections.responses.mineskin.MineSkinErrorResponse;
import net.skinsrestorer.shared.utils.connections.responses.mineskin.MineSkinUrlResponse;
import net.skinsrestorer.shared.utils.log.SRLogLevel;
import net.skinsrestorer.shared.utils.log.SRLogger;

public class MineSkinAPI
implements IMineSkinAPI {
    private static final String NAMEMCSKINURL = "https://namemc.com/skin/";
    private static final String NAMEMCIMGURL = "https://s.namemc.com/i/%s.png";
    private final SRLogger logger;
    private final MetricsCounter metricsCounter;
    private final Gson gson = new Gson();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r);
        t.setName("SkinsRestorer-MineSkinAPI");
        return t;
    });

    @Override
    public IProperty genSkin(String url, @Nullable SkinVariant skinVariant) throws SkinRequestException {
        url = url.startsWith(NAMEMCSKINURL) ? NAMEMCIMGURL.replace("%s", url.substring(24)) : url;
        AtomicInteger failedAttempts = new AtomicInteger(0);
        while (true) {
            try {
                return this.genSkinFuture(url, skinVariant).join();
            }
            catch (CompletionException e) {
                if (!(e.getCause() instanceof TryAgainException)) {
                    if (e.getCause() instanceof SkinRequestException) {
                        throw new SkinRequestException(e.getCause());
                    }
                    throw new SkinRequestException(e.getMessage());
                }
                failedAttempts.incrementAndGet();
                if (failedAttempts.get() < 5) continue;
                throw new SkinRequestException(Locale.MS_API_FAILED);
            }
            break;
        }
    }

    public CompletableFuture<IProperty> genSkinFuture(String url, @Nullable SkinVariant skinVariant) {
        return CompletableFuture.supplyAsync(() -> {
            String skinVariantString = skinVariant != null ? "&variant=" + skinVariant.name().toLowerCase() : "";
            try {
                Optional<Pair<Integer, String>> response = this.queryURL("url=" + URLEncoder.encode(url, "UTF-8") + skinVariantString);
                this.logger.debug("MineSkinAPI: Response: " + response);
                if (!response.isPresent()) {
                    throw new SkinRequestException(Locale.ERROR_UPDATING_SKIN);
                }
                switch (response.get().getLeft()) {
                    case 200: {
                        MineSkinUrlResponse urlResponse = this.gson.fromJson(response.get().getRight(), MineSkinUrlResponse.class);
                        return SkinsRestorerAPI.getApi().createPlatformProperty("textures", urlResponse.getData().getTexture().getValue(), urlResponse.getData().getTexture().getSignature());
                    }
                    case 400: 
                    case 500: {
                        String error;
                        MineSkinErrorResponse errorResponse = this.gson.fromJson(response.get().getRight(), MineSkinErrorResponse.class);
                        switch (error = errorResponse.getError()) {
                            case "Failed to generate skin data": 
                            case "Failed to change skin": {
                                this.logger.debug("[ERROR] MineSkin " + error + ", trying again... ");
                                TimeUnit.SECONDS.sleep(5L);
                                throw new TryAgainException();
                            }
                            case "No accounts available": {
                                this.logger.debug("[ERROR] MineSkin " + error + " for: " + url);
                                throw new SkinRequestException(Locale.ERROR_MS_FULL);
                            }
                        }
                        this.logger.debug("[ERROR] MineSkin Failed! Reason: " + error);
                        throw new SkinRequestException(Locale.ERROR_INVALID_URLSKIN);
                    }
                    case 429: {
                        MineSkinErrorDelayResponse errorDelayResponse = this.gson.fromJson(response.get().getRight(), MineSkinErrorDelayResponse.class);
                        if (errorDelayResponse.getDelay() != null) {
                            TimeUnit.SECONDS.sleep(errorDelayResponse.getDelay().intValue());
                        } else if (errorDelayResponse.getNextRequest() != null) {
                            Instant nextRequestInstant = Instant.ofEpochSecond(errorDelayResponse.getNextRequest().intValue());
                            int delay = (int)Duration.between(Instant.now(), nextRequestInstant).getSeconds();
                            if (delay > 0) {
                                TimeUnit.SECONDS.sleep(delay);
                            }
                        } else {
                            TimeUnit.SECONDS.sleep(2L);
                        }
                        throw new TryAgainException();
                    }
                }
            }
            catch (SkinRequestException | TryAgainException e) {
                throw new CompletionException(e);
            }
            catch (IOException e) {
                this.logger.debug(SRLogLevel.WARNING, "[ERROR] MineSkin Failed! IOException (connection/disk): (" + url + ") " + e.getLocalizedMessage());
                throw new CompletionException(new SkinRequestException(Locale.ERROR_MS_FULL));
            }
            catch (JsonSyntaxException e) {
                this.logger.debug(SRLogLevel.WARNING, "[ERROR] MineSkin Failed! JsonSyntaxException (encoding): (" + url + ") " + e.getLocalizedMessage());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.logger.debug("[ERROR] MineSkin Failed! Could not generate skin url: " + url);
            throw new CompletionException(new SkinRequestException(Locale.MS_API_FAILED));
        }, this.executorService);
    }

    private Optional<Pair<Integer, String>> queryURL(String query) throws IOException {
        for (int i = 0; i < 3; ++i) {
            try {
                InputStream is;
                this.metricsCounter.increment(MetricsCounter.Service.MINE_SKIN);
                HttpsURLConnection con = (HttpsURLConnection)new URL("https://api.mineskin.org/generate/url/").openConnection();
                con.setRequestMethod("POST");
                con.setRequestProperty("Content-length", String.valueOf(query.length()));
                con.setRequestProperty("Accept", "application/json");
                con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                con.setRequestProperty("User-Agent", "SkinsRestorer");
                con.setConnectTimeout(90000);
                con.setReadTimeout(90000);
                con.setDoOutput(true);
                con.setDoInput(true);
                if (!Config.MINESKIN_API_KEY.isEmpty()) {
                    con.setRequestProperty("Authorization", "Bearer " + Config.MINESKIN_API_KEY);
                }
                DataOutputStream output = new DataOutputStream(con.getOutputStream());
                output.writeBytes(query);
                output.close();
                StringBuilder outStr = new StringBuilder();
                try {
                    is = con.getInputStream();
                }
                catch (Exception e) {
                    is = con.getErrorStream();
                }
                try (DataInputStream input = new DataInputStream(is);){
                    int c = input.read();
                    while (c != -1) {
                        outStr.append((char)c);
                        c = input.read();
                    }
                }
                return Optional.of(new Pair<Integer, String>(con.getResponseCode(), outStr.toString()));
            }
            catch (IOException e) {
                if (i != 2) continue;
                throw e;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public MineSkinAPI(SRLogger logger, MetricsCounter metricsCounter) {
        this.logger = logger;
        this.metricsCounter = metricsCounter;
    }
}

